﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using TwoCamWPF.Settings;
using TwoCamWPF.Helpers;
using System.Reflection;

namespace TwoCamWPF.MainForm
{
    /// <summary>
    /// Логика взаимодействия для LeftPanelPreview.xaml
    /// </summary>
    public partial class LeftPanelPreview : UserControl, IDisposable
    {
        public LeftPanelPreview()
        {
            InitializeComponent();
        }

        List<MainPreviewModel> previews;
        internal void ApplySettings(Settings.ClassSettings settings)
        {
            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Главная форма: Настройки принимаю");

            previews =//new List<MainPreviewModel>();
            (settings["CamerasSettings"] as CamerasSettings)
                .Where(p => p.IsUsing)
                .Select(p => new MainPreviewModel(p)).ToList();
            DataContext = previews;
        }

        internal void SetSettings(Settings.ClassSettings settings)
        {
            previews.ForEach(p => p.Dispose());
        }

        public void Dispose()
        {
            if (previews != null)
            {
                previews.ForEach(p => p.Dispose());
                previews.Clear();
            }

        }
    }

    class MainPreviewModel : BaseViewModel, IDisposable, ICommand
    {
        TwoCamWPF.Settings.OneCameraSettings _settings;
        public MainPreviewModel(TwoCamWPF.Settings.OneCameraSettings settings)
        {
            _settings = settings;
            settings.device.Subscribe(this, (bmp) => Image = bmp.ToImageSource());
        }

        public string Name
        {
            get
            {
                return _settings.StreamName;
            }

        }

        ImageSource _Image;
        public ImageSource Image
        {
            get
            {
                return _Image;
            }
            set
            {
                _Image = value;
                _Image.Freeze();
                RaisePropertyChanged("Image");
            }
        }

        int _MaxBuffer;
        public int MaxBuffer
        {
            get { return _MaxBuffer; }
            set
            {
                _MaxBuffer = value;
                RaisePropertyChanged("MaxBuffer");
            }
        }

        int _CurrentBuffer;
        public int CurrentBuffer
        {
            get { return _CurrentBuffer; }
            set
            {
                _CurrentBuffer = value;
                RaisePropertyChanged("MaxBuffer");
            }
        }

        public void Dispose()
        {
            _settings.device.Unsubscribe(this);
        }

        public bool CanExecute(object parameter)
        {
            return true;
        }

        public event EventHandler CanExecuteChanged;

        public void Execute(object parameter)
        {
            if (CanExecuteChanged != null)
                CanExecuteChanged(this, EventArgs.Empty);
            return;

        }
    }

}
